% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program NoiseMasking.m
[M,  map] = imread('Church.jpg',  'jpeg');         
M1 = rgb2gray(M);
Mn = mean2(M1);
Sz = size(M);
% Generating a white Gaussian noise image with standard
% deviation s
s = 16; 
noiseI = s*randn(Sz(1),  Sz(2));
M2 = uint8(double(M1) + noiseI);  % noise is double, so make M1
                                  % double, too
showImage(M2,   'grayscale');

s = 96; 
noiseI = s*randn(Sz(1),  Sz(2));
M3 = uint8(double(M1) + noiseI);
showImage(M3,   'grayscale');
